# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # First move: Cooperate
    
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check if in the last two rounds
    if current_round >= total_rounds - 1:
        return "D"
    
    # Analyze opponent's code for deterministic strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    tit_for_tat = "tit for tat" in opponent_program_code.lower() or "mirror" in opponent_program_code.lower()
    
    if always_defect:
        return "D"
    elif always_cooperate:
        # Defect every 3rd round to maximize payoff
        if current_round % 3 == 0:
            return "D"
        else:
            return "C"
    elif tit_for_tat:
        # Mirror opponent's last move with 10% chance of forgiveness
        if random.random() < 0.1 and opp_history[-1] == "D":
            return "C"
        else:
            return opp_history[-1]
    else:
        # Default to Tit-for-Tat with forgiveness
        if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
            return "D"  # Switch to always defect if opponent defects twice in a row
        
        if random.random() < 0.1 and opp_history[-1] == "D":
            return "C"  # 10% chance to forgive
        else:
            return opp_history[-1]